%##### write the page header (the variable $header is defined below)

<& $header, %ARGS &>

%##### write the page body. This is the URI requested by the browser
%##### made available via the Apache Request Object, $r (see the Mason manual)

<& $r->uri(),%ARGS &>


%#### write the page footer

<& 'footer.cmp', %ARGS &>

%##### Done With Display Code #######


%##### A components "init" section always gets called first by Mason.
%##### It is traditionally placed at the bottom of the page, 
%##### after all display code.
%##### This is where you can set up variables used by the display components, 
%##### and do any processing that must be done for each page.

<%init>

# let's get the name of the current virtual host, and serve a different HTML 
# header for each of two different virtual hosts

# first, we can use the Apache Request object, $r, to get a hash of headers

my %hheaders = $r->headers_in;

# now we can set a key in the %ARGS hash called 'server' for future reference
# (the %ARGS hash is automatically filled with all CGI variables, and we 
# can add extra parameters to it and pass it to our sub-components)
 
$ARGS{'server'} = $hheaders{'Host'};

my $header;

if( $ARGS{'server'} =~ /myexamplesiteone\.com/ )
{
    $header = "header_one.cmp";
}
else
{
    $header = "header.cmp";
}

</%init>
